/*************************************************************************************/
/* Pprava situace																	 */
/*************************************************************************************/
USE TechEd2012Goran

SET STATISTICS TIME ON
SET STATISTICS IO ON
-- Execution plans

-- Najdi pracovnky, kte maj schvlen alespo jeden zznam
-- Kter podoba dotazu bude nejrychlej?

/***************************************************************************************/
/* Vechno sJOINuj a zafiltruj. Jsou tam duplicity? Zatracen JOIN, pome DISTINCT... */
/***************************************************************************************/
DBCC DROPCLEANBUFFERS 
SELECT DISTINCT Pracovnik.PracovnikID, Pracovnik.KrestniJmeno
	FROM Pracovnik
	INNER JOIN TimesheetItem
		ON (TimesheetItem.PracovnikID = Pracovnik.PracovnikID)
	WHERE
		(TimesheetItem.SchvalenoKdy IS NOT NULL)

/***************************************************************************************/
/* Najdi schvlen zznamy a vezmi pracovnky na nich. Je pracovnk mezi nimi?		   */
/***************************************************************************************/
DBCC DROPCLEANBUFFERS 
SELECT Pracovnik.PracovnikID, Pracovnik.KrestniJmeno FROM Pracovnik
	WHERE PracovnikID IN (
		SELECT PracovnikID FROM TimesheetItem
			WHERE TimesheetItem.SchvalenoKdy IS NOT NULL)

/***************************************************************************************/
/* Najdi schvlen a seskup je podle pracovnka. K pracovnkovi dohledej jmno.		   */
/***************************************************************************************/
DBCC DROPCLEANBUFFERS
SELECT Pracovnik.PracovnikID, Pracovnik.KrestniJmeno FROM Pracovnik
	WHERE PracovnikID IN (
		SELECT PracovnikID FROM TimesheetItem
			WHERE TimesheetItem.SchvalenoKdy IS NOT NULL
			GROUP BY PracovnikID)			